<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Auth;
use App\Http\Requests;
use App\Models\Func;
use App\Models\Group;
use App\Models\GroupPermission;

class GroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $list = Group::where('id',">=",Auth::user()->group_id)->get();
        return view("sales.group.list", ["list"=>$list]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view("sales.group.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate($request, [
            'name' => 'required'
        ]);

        $group = Group::create(array( "name"=>$request->input("name") ));
        
        foreach ($request->input("func_id") as $k => $v) {
            $group->permissions()->save(new GroupPermission(array(
                "func_id" => $k,
                "permission" => $v
            )));
        }

        return redirect("/group")->with('message', "權限 ".$request->input("name")." 新增成功");

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Group $group)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Group $group)
    {
        //
        return view("sales.group.edit", compact('group'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Group $group)
    {
        //
        $this->validate($request, [
            'name' => 'required'
        ]);

        $group->name = $request->input("name");
        $group->save();

        foreach ($request->input("func_id") as $k => $v) {
            if( !count($group->permissions()->whereFuncId($k)->get()) ) {
                $group->permissions()->save(new GroupPermission(array(
                    "func_id" => $k,
                    "permission" => $v
                )));
            } else {
                $group->permissions()->whereFuncId($k)->update(array(
                    "permission" => $v
                ));
            }
        }

        return redirect("/group")->with('message', "權限 ".$request->input("name")." 修改成功");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Group $group)
    {
        //
        $group->permissions()->delete();
        return response()->json($group->delete());
    }
}
