<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Auth;
use App\Models\Group;
use App\Http\Requests;
use App\Models\User;

class UserController extends Controller
{
    
    public function __construct(){
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $list = User::where("group_id", ">=", Auth::user()->group_id)->get();

        return view("sales.user.list",['list'=>$list]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view("sales.user.create", ['opts'=>$this->opts()]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $validator = $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|same:password_confirmation',
            'group_id' => 'required'
        ]);

        $group = Group::find($request->input('group_id'));
        $user = new User([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'password' => bcrypt($request->input('password'))
        ]);

        if($group->user()->save($user)) {
            return redirect("/user")->withMessage("帳號 <b>"+$request->input('name')+"</b> 新增成功");
        } else {
            return redirect()->back()->withError("帳號 <b>"+$request->input('name')+"</b> 新增失敗");
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        //
        return view("sales.user.edit", compact('user'), ['opts'=>$this->opts()]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        //
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'same:password_confirmation',
            'group_id' => 'required'
        ]);

        $user->name = $request->input('name');
        $user->email = $request->input('email');
        if($request->has('password')) 
            $user->password = bcrypt($request->input('password'));
        $user->group_id = $request->input('group_id');

        if($user->save()) {
            return redirect("/user")->withMessage("帳號 <b>".$request->input('name')."</b> 修改成功");
        } else {
            return redirect()->back()->withError("帳號 <b>"+$request->input('name')+"</b> 修改失敗");
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        //
        return response()->json($user->delete());
    }

    public function opts($value='')
    {
        return Group::where("id",">=",Auth::user()->group_id)->lists('name', 'id');
    }
}
