<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Text;
use Validator;
use Auth;
use Response;
use Excel;
use PHPExcel_Style_NumberFormat;

class DashboardController extends Controller
{
    //
    public function admin(Request $request)
    {
        return view('admin.dashboard');
    }
    //
    public function sales(Request $request)
    {
        $sales = Auth::guard('sales')->user();
        return view('sales.dashboard');
    }

    //導向
    public function index(Request $request)
    {
        return view('client.index');
    }

    //test (fmaily)
    public function testabc(Request $request)
    {
        return view('client.family.testabc');
    }
    //首頁 (fmaily)
    public function family_index(Request $request)
    {
        return view('client.family.index');
    }

    public function family_submit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required|unique:text',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
            return Response::json(array(
                'status' => 1,
                'errors' => $validator->getMessageBag()->toArray()

            ), 200); // 400 being the HTTP code for an invalid request.
        }

        $active = new Text;
        $active->name = $request->input("name");
        $active->text = $request->input("text");
        $active->cellphhone = $request->input("phone");
        $active->email = $request->input("email");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }

    //活動一
    public function info()
    {
        $info = Text::all();
        return view('sales.info',["list"=>$info]);
    }
    public function excel()
    {   
        Excel::create('報名資訊(Family)', function($excel) {
            $excel->sheet('報名資訊(Family)', function($sheet) {
                $data = Text::orderBy('created_at','asc')->get();
                $sheet->row(1, array('發票','姓名','手機號碼','電子信箱'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->text, $v->name, $v->cellphhone, $v->email,$v->created_at));
                }
            });
        })->export('xls');
    }
}
