<?php 

namespace App\Http\ViewComposers;

use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Contracts\View\View;

use Auth;
use Route;
use Session;
use App\Models\DomainModel;
use App\Models\DomainGroup;
use App\Models\Domain;
use App\Models\Sales;
use App\Models\Bill;
use App\Models\DomainGroupPermission;
use App\Models\Logo;
use Carbon\Carbon;
use App\Models\Client\ClientDomainModel;
use App\Models\Client\ClientDomainGroup;
use App\Models\Client\ClientDomainGroupPermission;

class BridgeWithComposer {

    /**
     * The user repository implementation.
     *
     * @var UserRepository
     */

    public function __construct(Request $request)
    {
        $this->request = $request;
        $this->editable = false;
    }
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */


    public function compose(View $view)
    {
        $func = [];

        /**
         * 我們的畫面
         */
        if($this->request->server('HTTP_HOST')=='admin.bridge-with.com'){
            foreach(DomainModel::whereNull("parent_id")->orderBy('sort')->get() as $v) {
                $func[] = $v;
            }
            foreach(ClientDomainModel::whereNull("parent_id")->orderBy('sort')->get() as $v) {
                $func1[] = $v;
            }
            $editable = true;
            $view->with([
                'navs1' => $func,
                'navs2' => $func1,
                'editable1' => $editable
            ]);     
            return;
        }
        /**
         * 客戶畫面
         */
        if(null==Auth::guard('sales')->user() ){ 
            $domain = Domain::where('domain_name',$this->request->server('HTTP_HOST'))->first();
            $client_domain_group = ClientDomainGroup::where('domain_id',$domain->id)->first();
            $domain_group = DomainGroup::where('domain_id',$domain->id)->first();
            $sales = Sales::where('domain_group_id',$domain_group->id)->first();
            $permission = $this->getPermissions($client_domain_group->client_group_permissions);
            Session::put("permission",$permission);
            foreach(ClientDomainModel::whereNull("parent_id")->orderBy('sort')->get() as $v) {
                if(  in_array($v->slug, $permission)  ) 
                    $func[] = $v;
            }
            $editable = false;
            $view->with([
                'navs2' => $func,
                'editable2' => $editable,
                'logo' => $domain->logo->logo,
                'domain'=> $domain,
                'sales' => $sales
            ]);
            return;
        }
        /**
         * 店家畫面
         */
        if(null!=Auth::guard('sales')->user()){
            /**
             * 前台
             * @var [type]
             */
            $domain = Domain::where('domain_name',$this->request->server('HTTP_HOST'))->first();
            $client_domain_group = ClientDomainGroup::where('domain_id',$domain->id)->first();
            $domain_group = DomainGroup::where('domain_id',$domain->id)->first();
            $sales = Sales::where('domain_group_id',$domain_group->id)->first();
            $permission1 = $this->getPermissions($client_domain_group->client_group_permissions);
            Session::put("permission",$permission1);
            foreach(ClientDomainModel::whereNull("parent_id")->orderBy('sort')->get() as $v) {
                if(  in_array($v->slug, $permission1)  ) 
                    $func1[] = $v;
            }
            /**
             * 後台
             */

            $permission = $this->getPermissions(Auth::guard('sales')->user()->domain_group->group_permissions);
            Session::put("permission",$permission);
            foreach(DomainModel::whereNull("parent_id")->orderBy('sort')->get() as $v) {
                if(  in_array($v->slug, $permission)  ) 
                    $func[] = $v;
            }

            $editable = false;
            foreach (DomainGroupPermission::whereDomainGroupId(Auth::guard('sales')->user()->domain_group_id)->get() as $k => $v) {
                if( null!=$this->request->segment(1) && $v->doomain_model->slug==$this->request->segment(1) )
                    $editable = $v->permission==2?true:false;
            }

            /**
             * [花費金額 總額]
             * @var [type]
             */
            $now = Carbon::now('Asia/Taipei');
            Carbon::setTestNow($now); 
            $now_year = Carbon::createFromFormat('Y-m-d H:i:s', $now)->format('Y'); // 現在時間(年)
            $now_month = Carbon::createFromFormat('Y-m-d H:i:s', $now)->format('m'); // 現在時間(月)        
            $bill = Bill::where('domain_id',$domain->id)->whereYear('created_at','=',$now_year)->whereMonth('created_at','=',$now_month)->first();
            $bill_detail = $bill->bill_detail;
            $total_pay = $bill_detail->SUM('pay');

            /**
             * [LOGO]
             * @var [type]
             */
            
            $view->with([
                'navs1' => $func,
                'navs2' => $func1,
                'editable1' => $editable,
                'total_pay' => $total_pay,
                'logo' => $domain->logo->logo,
                'domain'=>$domain,
                'sales' => $sales
            ]);
            return;
        }
    }

    public function getPermissions($permissions)
    {
        $permission = array();
        foreach($permissions as $p) {
            if( $p->permission>=1) {
                $permission[] = $p->doomain_model->slug;
            }
            
        }

        return $permission;
    }
}
