<?php
// 帶入各個 router 所需的基本資料
View::composers([
    'App\Http\ViewComposers\AdminComposer' => "*",
    ]);

// 行政
Route::group(['domain' => 'admin.web-sop.com'], function () {

    Route::get('login', 'Auth\AuthController@getLogin');
    Route::post('login', 'Auth\AuthController@postLogin');
    Route::get('logout', 'Auth\AuthController@logout');
    // 登入審核
    Route::group(['middleware' => 'auth'], function() {
        Route::get("/", 'DashboardController@sales');
        Route::resource('func', 'Admin\FuncController');
        Route::resource('user', 'Admin\UserController');
        Route::resource('group', 'Admin\GroupController');

    });
    Route::post('ckeditor_photo', 'PhotoController@admin_ckeditor_photo');

});





/**
 * 店家前台
 */
Route::get("/", 'DashboardController@index'); //導向

Route::get("2017familymart", 'DashboardController@family_index'); //首頁
Route::post("family_submit", 'DashboardController@family_submit'); //首頁
Route::get("testabc", 'DashboardController@testabc'); //首頁


Route::group(['prefix' => 'manager'], function() {
    Route::get('login', 'Auth\AuthController@getLogin');
    Route::post('login', 'Auth\AuthController@postLogin');
    Route::get('logout', 'Auth\AuthController@logout');
    // 登入審核
    Route::group(['middleware' => 'auth'], function() {
        Route::get("/", 'DashboardController@sales');

        //Family
        Route::get("info", 'DashboardController@info');
        Route::get("excel", 'DashboardController@excel');

    });
});