<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Models\Sales;

class Client extends Authenticatable
{
    public $timestamps = true;
    protected $dates = ['created_at', 'updated_at'];
    protected $guarded = ['id'];

    protected $fillable = [
        'client_type_id','domain_id','provider_id','email', 'password',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    public function client_detail()
    {
        return $this->hasOne('App\Models\ClientDetail');
    }
    public function social_client()
    {
        return $this->hasOne('App\Models\SocialClient','id','provider_id');
    }
    public function client_type()
    {
        return $this->belongsTo('App\Models\ClientType');
    }
}
