<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 20)->comment('姓名');
            $table->string('email', 120)->unique()->comment('登入帳號兼email');
            $table->string('password', 120);
            $table->integer('group_id')->unsigned()->comment('角色ID');
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::table('users', function (Blueprint $table) {
            $table->foreign('group_id')->references('id')->on('groups');
            $table->index(['email', 'name']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function(Blueprint $table){
            $table->dropIndex(['email', 'name']);
            $table->dropForeign('users_group_id_foreign');
        }); 

        Schema::drop('users');
    }
}
