<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_details', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('client_id')->unsigned()->comment("所屬主帳號");
            $table->string("name")->comment("姓名");
            $table->string("address", 255)->nullable()->comment("地址");
            $table->string("email", 255)->nullable()->comment("email");
            $table->string("mobile",20)->nullable()->comment("手機");
            $table->date("birthday")->nullable()->comment("生日");
            $table->timestamps();
        });

        Schema::table('client_details', function (Blueprint $table) {
            $table->foreign('client_id')->references('id')->on('clients');
            $table->index(['name', 'client_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::table('client_details', function(Blueprint $table){
            $table->dropIndex(['name', 'client_id']);
            $table->dropForeign('client_details_client_id_foreign');
        }); 

        Schema::drop('client_details');
    }
}
