<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEditablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('editables', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("client_id")->unsigned()->comment("所屬客戶");
            $table->morphs("editable");
            $table->timestamps();
        });

        Schema::table('editables', function (Blueprint $table) {
            $table->foreign('client_id')->references('id')->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('editables', function(Blueprint $table){
            $table->dropForeign('editables_client_id_foreign');
        }); 

        Schema::drop('editables');
    }
}
