<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFuncsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('funcs', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', 20)->comment('功能名稱');
            $table->string('slug', 30)->comment('功能代碼');
            $table->integer('sort')->default(1);
            $table->boolean('divider')->default(false);
            $table->integer('parent_id')->nullable()->comment('上層功能ID');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('funcs');
    }
}
