var elixir = require('laravel-elixir');
// var Task = Elixir.Task;

/*
 |--------------------------------------------------------------------------
 | Elixir Asset Management
 |--------------------------------------------------------------------------
 |
 | Elixir provides a clean, fluent API for defining some basic Gulp tasks
 | for your Laravel application. By default, we are compiling the Sass
 | file for our application, as well as publishing vendor resources.
 |
 */

elixir(function(mix) {
    mix
    .copy('./node_modules/semantic-ui/src/themes/default/assets/*', 'public/')
    .copy('./node_modules/semantic/dist/semantic.css', 'public/css/semantic.css')
    .less([
        './node_modules/pickadate.js/lib/themes-source/base.less',
        './node_modules/pickadate.js/lib/themes-source/base.date.less',
        './node_modules/pickadate.js/lib/themes-source/base.time.less',
        './node_modules/pickadate.js/lib/themes-source/default.less',
        './node_modules/pickadate.js/lib/themes-source/default.date.less',
        './node_modules/pickadate.js/lib/themes-source/default.time.less'
    ], 'public/css/pickadate.css')
    .less('admin.less', 'public/css/admin.css')
    .less('sales.less', 'public/css/sales.css')
    .less('client.less', 'public/css/client.css')
    .scripts([
        './node_modules/jquery/dist/jquery.js',
        './node_modules/jquery-address/src/jquery.address.js',
        './node_modules/pickadate.js/lib/picker.js',
        './node_modules/pickadate.js/lib/picker.date.js',
        './node_modules/pickadate.js/lib/picker.time.js',
        './node_modules/pickadate.js/lib/legacy.js',
        './node_modules/semantic-ui/dist/semantic.js', 
        'jquery.dataTables.min.js',
        'dataTables.semanticui.min.js',
        'main.js'
    ], "public/js/main.js")
    .copy('resources/assets/js/admin/*.js', 'public/js/admin/')
    .copy('resources/assets/js/sales/*.js', 'public/js/sales/')
    .copy('resources/assets/js/client/*.js', 'public/js/client/')
    .copy('resources/assets/js/dataTables.semanticui.min/*.js', 'public/js/dataTables.semanticui.min/')
    .copy('resources/assets/js/jquery.dataTables.min/*.js', 'public/js/jquery.dataTables.min/')
    .scripts([
        'admin.js'
    ], "public/js/admin.js")
    .scripts([
        'sales.js'
    ], "public/js/sales.js")
    .scripts([
        'client.js'
    ], "public/js/client.js")
    .browserSync({
        files: ['public/**/*', "resources/**/*", "app/**/*"],
        proxy: "gallop.dev"
    });
});
