@extends('sales.auth.layouts.app')
@section('content')
<div class="ui centered grid">
    <div class="sixteen wide mobile ten wide tablet six wide computer column">
        <h1 class="ui inverted center aligned header">
            <div class="content">Itoen</div>
        </h1>
        <form class="ui form left aligned segment" role="form" method="POST" action="{{ url('/manager/login') }}">
            {{ csrf_field() }}
            <div class="field">
                <label>Email</label>
                <input type="text" name="email" placeholder="account@mail.com">
            </div>
            <div class="field">
                <label>Password</label>
                <input type="password" name="password" placeholder="Please insert password">
            </div>
            <div class="field">
                <label for="captcha">Captcha</label>
                <div class="inline fields">
                    <div class="field">
                        <img src="{{ captcha_src('flat') }}" alt="">
                    </div>
                    <div class="field">
                        <input type="text" name="captcha" id="captcha" placeholder="insert captcha">
                    </div>
                </div>
            </div>
            <div class="field">
                <div class="ui checkbox">
                    <input type="checkbox" name="remember" id="remeber" />
                    <label for="remeber">Remember me</label>
                </div>
            </div>
            <div class="field">
                @if(count($errors) > 0)
                <div class="ui error message visible">
                    <div class="ui dividing header">登入失敗</div>
                    @foreach ($errors->all() as $error)
                        <p>{{ $error }}</p>
                    @endforeach
                </div>
                @endif 
            </div>
            <button class="fluid ui blue button" type="submit">Sign in</button>
        </div>
    </div>
</div>
@endsection
