@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        <a href="javascript:window.history.back();"><i class="arrow left icon"></i></a> 
        編輯功能
    </h1>
    <div class="ui divider"></div>
    <form method="POST" class="ui form" action="{{ url('/func/'.$func->id) }}">
        {{ csrf_field() }}
        {{ method_field("PUT") }}
        <div class="fields">
            <div class="field">
                <label for="name">功能名稱</label>
                <input type="text" name="name" id="name" value="{{ $func->name }}">
            </div>
            <div class="field">
                <label for="slug">功能代碼</label>
                <input type="text" name="slug" id="slug" value="{{ $func->slug }}">
            </div>
            <div class="field">
                <label for="">功能分組</label>
                <div class="ui checkbox">
                    <input type="checkbox" name="divider" id="divider" value="1">
                    <label for="">分隔線</label>
                </div>
            </div>
        </div>
        <div class="fields">
            <div class="field">
                <label for="parent">上層</label>
                <select name="parent" id="parent" value="{{ $func->parent_id }}" class="ui selection dropdown">
                    <option value="">請選擇上層功能</option>
                    @foreach($opts as $k => $v)
                    <option value="{{$k}}" @if(!is_null($func->parent_id) && $func->parent_id==$k) selected @endif>
                        {{$v}}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
        @if (count($errors) > 0)
            @include('partials.error', ['errors'=>$errors])
        @endif
        <div class="ui divider"></div>
        <div class="field center aligned">
            <button type="submit" class="ui green icon button">
                <i class="check icon"></i> 儲存功能
            </button>
            <a href="javascript:window.history.back();" class="ui icon button">
                <i class="arrow left icon"></i> 取消，回上頁
            </a> 
        </div>
    </form>
</div>
@endsection