@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        角色管理 
        @if($editable)
        <a href="{{ url('/group/create') }}" class="ui green small button">
            <i class="plus icon"></i> 新增角色
        </a>
        @endif
    </h1>
    <div class="ui divider"></div>
    <table id="group-table" class="ui very basic table">
        <thead>
            <tr>
                <th>角色</th>
                <th width="100"></th>
            </tr>
        </thead>
        <tbody>
        @if( !count($list) )  
            <tr>
                <td colspan="2">
                    <h1 class="ui grey center aligned header">
                        <i class="warning icon"></i>
                        <div class="content">沒有角色</div>
                    </h1>
                </td>
            </tr>
        @endif
        @foreach($list as $v)
            <tr id="group-{{ $v->id }}">
                <td>{{ $v->name }}</td>
                <td class="right aligned">
                    <a href="{{ url('/group/'.$v->id.'/edit') }}" class="ui icon small orange button">
                        <i class="pencil icon"></i>
                    </a>
                    @if($editable)
                    <a onclick="notification('group', {{ $v->id }})" class="ui icon small red button">
                        <i class="trash icon"></i>
                    </a>
                    @endif
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endsection

@section("script")
<script type="text/javascript">
    @include('partials.message') 
    
    $("#group-table").DataTable();

    function notification(type, id) {
        if( confirm("刪除可能會影響到擁有此角色的帳號，是否確認刪除？") ) {
            deleteItem(type, id);
        }
    }
</script>
@endsection