@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        參加者資料
    </h1>
    <div class="ui divider"></div>
    @if( !count($list) )  
    <h1 class="ui grey header">
        <i class="warning icon"></i>
        <div class="content">沒有資料</div>
    </h1>
    @else
    <table id="activity_table" class="ui unstackable table">
        <thead>
            <tr>
                <th>發票號碼</th>
                <th>姓名</th>
                <th>手機號碼</th>
                <th>電子信箱</th>
                <th>時間</th>
            </tr>
        </thead>
        <tbody>
            @foreach($list as $v) 
            <tr>
                <td><p>{{ $v->text }}</p></td>
                <td><p>{{ $v->name }}</p></td>
                <td><p>{{ $v->cellphhone }}</p></td>
                <td>{{ $v->email }}</td>
                <td>{{ $v->created_at }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif
    
    </div>
</div>
@endsection

@section("script")


<script type="text/javascript">
    
    @include('partials.message')
$(document).ready( function () {
    $('#activity_table').DataTable({
        "pageLength": 10,
        "lengthChange": false,
        "language": {
            "search": "search the key:",
            "searchPlaceholder": "Search",
            "zeroRecords": "找不到相對應的值，請重新輸入",
            "info": "第 _START_ 到 _END_ 筆，共 _TOTAL_ 筆",
            "infoFiltered": ""

    },
        "order": [[ 1, 'desc' ]]

    });
    var table = $('#activity_table').DataTable();

} );

</script>
@endsection