@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        參加者資料
    </h1>
    <div class="ui divider"></div>
    @if( !count($list) )  
    <h1 class="ui grey header">
        <i class="warning icon"></i>
        <div class="content">沒有資料</div>
    </h1>
    @else
    <table id="activity_table" class="ui unstackable table">
        <thead>
            <tr>
                <th>姓名</th>
                <th>性別</th>
                <th>縣市</th>
                <th>郵遞區號</th>
                <th>收件地址</th>
                <th>電話</th>
                <th>年齡</th>
                <th>電子信箱</th>
                <th>心得</th>
            </tr>
        </thead>
        <tbody>
            @foreach($list as $v) 
            <tr>
                <td><p>{{ $v->name }}</p></td>
                <td>
                    @if($v->sex == 0)
                        <p>男</p>
                    @else
                        <p>女</p>
                    @endif
                </td>
                <td><p>{{ $v->city }}</p></td>
                <td><p>{{ $v->city_num }}</p></td>
                <td>{{ $v->address }}</td>
                <td>{{ $v->phone }}</td>
                <td>{{ $v->age }}</td>
                <td><p>{{ $v->email }}</p></td>
                <td><p>{{ $v->experience }}</p></td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif
    
    </div>
</div>
@endsection

@section("script")


<script type="text/javascript">
    
    @include('partials.message')
$(document).ready( function () {
    $('#activity_table').DataTable({
        "pageLength": 10,
        "lengthChange": false,
        "language": {
            "search": "search the key:",
            "searchPlaceholder": "Search",
            "zeroRecords": "找不到相對應的值，請重新輸入",
            "info": "第 _START_ 到 _END_ 筆，共 _TOTAL_ 筆",
            "infoFiltered": ""

    },
        "order": [[ 1, 'desc' ]]

    });
    var table = $('#activity_table').DataTable();

} );

</script>
@endsection