@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        <a href="javascript:window.history.back();"><i class="arrow left icon"></i></a> 
        編輯帳號
    </h1>
    <div class="ui divider"></div>
    <form method="POST" class="ui form" action="{{ url('/user/'.$user->id) }}">
        {{ csrf_field() }}
        {{ method_field("PUT") }}
        <div class="fields">
            <div class="field">
                <label for="name">姓名</label>
                <input type="text" name="name" id="name" value="{{ $user->name }}">
            </div>
            <div class="field">
                <label for="email">帳號</label>
                <input type="email" name="email" id="email" value="{{ $user->email }}">
            </div>
        </div>
        <h4>修改密碼</h4>
        <div class="fields">
            <div class="field">
                <label for="password">輸入新密碼</label>
                <input type="password" name="password" id="password">
            </div>
            <div class="field">
                <label for="password_confirmation">確認新密碼</label>
                <input type="password" name="password_confirmation" id="password_confirmation">
            </div>
        </div>
        <div class="fields">
            <div class="field">
                <label for="group_id">角色</label>
                <select name="group_id" id="group_id" value="{{ $user->group_id }}" class="ui selection dropdown">
                    <option value="">請選擇角色</option>
                    @foreach($opts as $k => $v)
                    <option value="{{$k}}" @if(!is_null($user->group_id) && $user->group_id==$k) selected @endif>
                        {{$v}}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
        @if (count($errors) > 0)
            @include('partials.error', ['errors'=>$errors])
        @endif
        <div class="ui divider"></div>
        <div class="field center aligned">
            @if($editable)
            <button type="submit" class="ui green icon button">
                <i class="check icon"></i> 儲存帳號
            </button>
            @endif
            <a href="javascript:window.history.back();" class="ui icon button">
                <i class="arrow left icon"></i> 取消，回上頁
            </a> 
        </div>
    </form>
</div>
@endsection
