<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=640, user-scalable=no">
    <title>伊藤園</title>
    <meta name="description" content="活動期間於全家便利商店購買伊藤園全系列商品任兩瓶，憑活動時間內購買之發票與明細至活動網站登錄發票號碼，即可參加沖繩來回雙人機票等抽獎活動。" />
    <meta name="keywords" content="全家,全家便利商店,便利商店,茶飲,飲料,沖繩伊藤園,伊藤園,TEASTEA,抽獎,發票,發票抽獎,發票登錄活動,發票登錄,統一發票,統一發票抽獎,沖繩,機票,抽機票,沖繩機票" />
    <link rel="stylesheet" type="text/css" href="/family/css/reset.css" />
    <link rel="stylesheet" type="text/css" href="/family/css/slicknav.css">
    <link rel="stylesheet" type="text/css" href="/family/css/main.css" />
    <link rel="stylesheet" href="/css/plugins/sweetalert.min.css">
    <script type="text/javascript" src="/family/js/jquery-1.11.0.min.js"></script>
    <script type="text/javascript" src="/family/js/jquery.slicknav.min.js"></script>
    <script type="text/javascript" src="/family/js/site.js"></script>
</head>

<body>
    <ul id="menu" style="display:none;">
        <li><a href="/2017familymart">回首頁</a></li>
        <li><a href="#rule">活動辦法</a></li>
        <li><a href="#receipt">登錄發票</a></li>
        <li><a href="#intro">產品介紹</a></li>
        <li><a href="#prize">中獎名單</a></li>
    </ul>
    <div class="headbar"></div>
    <div class="main">
        <div class="main_img">
            <img src="/family/img/main-01.jpg" class="full">
            <a href="#receipt" class="bubble"><img src="/family/img/bubble-01.png" class="full"></a>
            <div class="main_item_01"><img src="/family/img/main-item-01.png" class="full"></div>
            <div class="main_item_02"><img src="/family/img/main-item-02.png" class="full"></div>
            <div class="logo"><img src="/family/img/logo.png" class="full"></div>
        </div>
        <div id="rule">
            <h2><img src="/family/img/tit-01.jpg" class="full"></h2>
            <div class="box1">
                <h3><img src="/family/img/subtit-01.png"><h3>
                <p class="flex"><span class="left">全家便利商店所販售之伊藤園全系列商品任兩瓶<br> 
            (お~いお茶、TEAS’TEA 品牌系列商品、日本進口商品：京都宇治抹茶綠茶冷泡版、伊藤園金烏龍茶、冷梅的實力等) </span>
                    <span class="right"><img src="/family/img/img-01.png" /></span>
                </p>
                <h3><img src="/family/img/subtit-02.png"></h3>
                <p>2017/08/30~2017/10/10<br> (活動網站登錄截止時間為 2017/10/11 23:59) </p>
                <p>活動期間內，凡於全家便利商店購買伊藤園商品(不含 FamilyMart Collection 商品)，憑活動時間內(2017/08/30~2017/10/10)購買之發票與明細，至活動網站登錄發票號碼，即可參加沖繩來回雙人機票(經濟艙)等抽獎活動。</p>
                <p>中獎者需提供發票正本與購買明細。活動結束後將於2017 年 10 月 20 日(五)前於活動網頁上公佈中獎名單，由主辦單位通知中獎者，中獎者應於 2017 年 11 月 3 日(五)前(以郵戳為憑)以掛號寄回兌獎相關資料，主辦單位於驗證確認後於 2017 年 11 月 10 日(五)前寄發獎品。</p>
                <p>如未於期限內檢附完整資料辦理完成上開事項，或所填寫之資料不正確或不真實或與參加抽獎時提供之資料不符而造成無法聯繫及寄送者，主辦單位得取消中獎資格。</p>
                <p>註：活動須填妥「真實姓名」、「正確電話號碼」、「正確電子信箱」，以利後續領獎通知。 </p>
                <img src="/family/img/award-01.png" class="full">
            </div>
            <img src="/family/img/hr-01.jpg" class="full">
            <div class="box1 bg1">
                <h2>網路抽獎相關注意事項</h2>
                <ul class="lr">
                    <li><span>01.</span>
                        <div>活動辦法及中獎名單依本次活動官網 <a href="http://www.okinawaitoen.com.tw/2017familymart" target="_blank" class="link">www.okinawaitoen.com.tw/2017familymart</a> 之公布為準。</div>
                    </li>
                    <li><span>02.</span>
                        <div>凡參加活動者，視同同意遵守本活動辦法，如有未盡事宜，悉依主辦單位之規定，主辦單位得自行增訂、修改、刪除或終止活動內容及獎項等細節之權利，無需進行事先通知或取得參與者同意。</div>
                    </li>
                    <li><span>03.</span>
                        <div>修改或變更後的活動內容及獎項等條款若在活動官網上公布，即有效替代先前本次活動官網公布的活動內容及獎項等條款或協議。</div>
                    </li>
                    <li><span>04.</span>
                        <div>參與者應隨時查閱最新版之活動內容條款，若參與者不接受本次活動官網於任何時間對本活動內容條款修改或變更後的結果，參與者得放棄參與資格。</div>
                    </li>
                    <li><span>05.</span>
                        <div>本活動範圍僅限臺、澎、金、馬地區。獎品配送地點僅限台灣、金門、澎湖、馬祖地區，所有獎項之聯絡及寄送以中獎者於登錄時填寫之資料為準，參加者請務必確認資料無誤及填載正確。若因資料填寫不實、不完整或不正確造成無法聯繫或無法寄送或寄送錯誤，則視同放棄權益並應自負其責，主辦單位不另行通知，主辦單位不接受中獎者變更聯絡住址或中獎者姓名(一切資料均以登錄參加時填載之資料為準)，以避免產生冒領獎項之情況。寄送獎品過程如發生任何毀壞、錯遞、延遲或遺失，主辦單位恕不負責。</div>
                    </li>
                    <li><span>06.</span>
                        <div>中獎者寄回之發票，將於活動結束後捐贈公益單位。</div>
                    </li>
                    <li><span>07.</span>
                        <div>如中獎證明字跡不易辨識，或殘缺不全，或銀漆被刮開、或銀漆毀壞，或有偽造、變造等情事，經主辦單位判定為無效者，或通訊資料有誤、不完整或不清楚，致無法聯絡者，或未遵守規定之期限或不配合規定之事項，均取消中獎資格。如涉及民、刑事責任者，將依法追究。</div>
                    </li>
                    <li><span>08.</span>
                        <div>中獎者同意配合主辦單位，將中獎者名單公佈於活動網站，以作為活動宣傳。 </div>
                    </li>
                    <li><span>09.</span>
                        <div>得獎者一旦簽收獎項後，若有遺失或被竊等喪失占有之情形，主辦單位不負補發獎項之責任。</div>
                    </li>
                    <li><span>10.</span>
                        <div>中獎者不得要求折抵現金、退換、轉售（讓）或折換其他物品。主辦單位並保有活動方式及活動贈品更換之權利。</div>
                    </li>
                    <li><span>11.</span>
                        <div>本活動如有任何因電腦、網路、電話、技術或其他不可歸責於主辦單位之事由，而使參與本活動者所登錄之資料有所遺失、錯誤、無法辨識或毀損所導致資料無效之狀況，主辦單位不負任何法律責任，參加者與中獎者亦不得異議。</div>
                    </li>
                    <li><span>12.</span>
                        <div>主辦單位有權檢視各活動參加者之活動參與行為及中獎情形是否涉嫌例：人為操作、蓄意偽造、短時間異常多筆參與行為、透過任何電腦程式參與活動、詐欺或以任何其他不正當的方式進行不實或虛偽活動參與行為，活動參加者因上述情形所獲得之活動資格及獎項，主辦單位保有取消得獎資格的權利，並保留法律追訴權。若有登錄資料不實或不正確，或有違反活動規範之行為，主辦單位保留變更、終止本活動及取消參加者參加活動資格及中獎之權利。</div>
                    </li>
                    <li><span>13.</span>
                        <div>本活動獎項屬於機會中獎，應依中華民國所得稅法及相關規定，辦理納稅及扣繳。如所領獎項依法須納稅者，而中獎之參與者未能依法繳納應繳稅額，即視為喪失得獎資格。納稅及扣繳規定由主辦單位於核獎時告知，且中獎者應提供必要資料予主辦單位辦理，未依主辦單位之規定提供必要資料者，亦視為喪失得獎資格。</div>
                    </li>
                    <li><span>14.</span>
                        <div>依本國稅法相關規定，獎項價值超過 NT$1,000 元者，將由主辦單位申報各類所得；超過NT$20,000 元者，主辦單位將依法向消費者收取後代付 10%(外籍者 20%)機會中獎稅金。</div>
                    </li>
                    <li><span>15.</span>
                        <div>參與者同意主辦單位於本此活動之目的範圍內得依個人資料保護法之規定蒐集、處理及利用參與者之個人資料，並於名單公布時得以必要之方式公告周知，使參與者知悉是否中獎及獎項。</div>
                    </li>
                    <li><span>16.</span>
                        <div>依個人資料保護法第三條規定得行使之權利及方式：活動參與者於身份獲確認後，得向主辦單位提出申請，以查詢、閱覽、製給複製本；或補充／更正、請求停止蒐集、處理、利用或刪除個人資料內容之一部或全部。</div>
                    </li>
                    <li><span>17.</span>
                        <div>主辦單位: 日商沖繩伊藤園股份有限公司台灣分公司保留活動相關內容修改之一切權利。客服專線：<a href="tel:0800-016-619" class="link">0800-016-619</a>。</div>
                    </li>
                </ul>
                <h2>雙人遊機票兌換券注意事項</h2>
                <ul class="lr">
                    <li><span>(1)</span>
                        <div>本贈獎兌換券每張價值 NT$24,000(含稅)，憑券向【勁新旅行社有限公司】兌換台北~沖繩來回經濟艙機票兩張。</div>
                    </li>
                    <li><span>(2)</span>
                        <div>本券使用期限(旅遊出發日期) : 2017 年 11 月 14 日起至 2018 年 05 月 15日止，逾期視同自動放棄。</div>
                    </li>
                    <li><span>(3)</span>
                        <div>雙人遊機票兌換券限中獎本人使用。機票中獎者本人與另一名同伴之訂位須同進同出，機票不可分開使用，訂位方式一律依贈票劵面上規定。</div>
                    </li>
                    <li><span>(4)</span>
                        <div>遇特殊假期如日本賞櫻旺季出發，機場稅、兵險或稅金、匯率波動，票價調漲，若有調動以新價為主，多出之部分則視同放棄，不得退還現金。</div>
                    </li>
                    <li><span>(5)</span>
                        <div>本券限一次使用完畢，恕無法兌換現金。</div>
                    </li>
                    <li><span>(6)</span>
                        <div>本券為有價證券，認券不認人，請妥善保管，若遺失恕不另行補發。</div>
                    </li>
                    <li><span>(7)</span>
                        <div>本券必須來回訂位確認方可開票；不可搭乘廉航班機、不可背書轉讓；機票開立後均不可更改及退票。</div>
                    </li>
                    <li><span>(8)</span>
                        <div>請於開票前郵寄掛號或是直接於旅行社前出示此兌換券，未出示者，不予抵用。</div>
                    </li>
                    <li><span>(9)</span>
                        <div>本券不得影印使用，需經由【勁新旅行社有限公司】蓋章後始生效力。</div>
                    </li>
                    <li><span>(10)</span>
                        <div> 機票使用限制，則須依航空公司規定辦理。機票訂位、行程等詳細內容依旅行社為準。</div>
                    </li>
                    <li><span>(11)</span>
                        <div> 中獎者需妥善保管機票旅遊抵用憑證至開票時使用，遺失或逾期兌換恕無法補發。</div>
                    </li>
                    <li><span>(12)</span>
                        <div> 機票旅遊抵用憑證如有偽造、變造、塗改，即一概無效，將當場註銷或收回，且不論是否 已完成開票，兌換人應自行承擔法律責任並負擔主辦單位因此所受之損害。</div>
                    </li>
                    <li><span>(13)</span>
                        <div> 旅遊獎項並不包括旅行平安險、護照新辦(更換)費用、辦理簽證費用、簽證、超重行李寄倉費、前往機場之交通安排及費用、部份膳食支出、中獎者個人及其隨行人員消費、機場稅、燃料費及以上未包含的其他費用，相關開支或費用由中獎者自行承擔。</div>
                    </li>
                    <li><span>(14)</span>
                        <div> 中獎者同意自行承擔所有旅行中風險，中獎者若有需求，請自行投保旅行平安險。</div>
                    </li>
                    <li><span>(15)</span>
                        <div> 中獎者若為未成年人，需法定代領人陪同兌獎且雙人遊需指定其法定代理人為隨行人員。 其他未註明事項與使用詳情請洽【勁新旅行社有限公司】專屬服務窗口楊小姐 <a href="tel:02-2511-4488" class="link">02-2511-4488</a></div>
                    </li>
                </ul>
                <img src="/family/img/img-02.png" class="full">
            </div>
        </div>
        <div id="receipt" class="bg2">
            <div class="box1">
                <h2><img src="/family/img/tit-02.png" class="full"></h2>
                <p class="f1 align_center">(購買任兩瓶伊藤園產品的全家便利商店發票)</p>
                <div class="form_wrap">
                    <label>發票號碼 (2碼英文+8碼數字)</label>
                    <input type="text" placeholder="AX-12345678"  maxlength="11" id="text" ><span></span>
                </div>
                <div class="form_wrap">
                    <label>真實姓名</label>
                    <input type="text" placeholder="王小明" maxlength="10"  id="name" >
                </div>
                <div class="form_wrap">
                    <label>手機號碼</label>
                    <input type="text" placeholder="0912345678" maxlength="10" id="phone" >
                </div>
                <div class="form_wrap">
                    <label>電子信箱</label>
                    <input type="email" placeholder="E-mail 信箱" id="email" >
                </div>
                <div class="form_wrap">
                    <div class="checkbox_wrap"><input type="checkbox" id="contact1" name="radio"><label for="contact1">資料皆為正確內容 (請填寫正確以利後續兌獎確認)。</label></div>
                    <div class="checkbox_wrap"><input type="checkbox" id="contact2" name="checkbox"><label for="contact2">我已詳閱<a href="#rule" style="color:blue">活動辦法</a>及注意事項說明</label></div>
                </div>
                <div class="btn_wrap flex">
                    <input type="reset" class="btn1" onclick="done();" value="清除重填">
                    <input type="submit" class="btn1" onclick="done();" value="完成送出">
                </div>
            </div>
        </div>
        <div id="intro">
            <div class="box1">
                <h2>產品介紹</h2>
                <p>伊藤園是日本茶飲第一大品牌！尤其是「伊藤園綠茶」更是伊藤園的長年的熱銷商品；另有口味更濃厚的「伊藤園濃味綠茶」。在台灣還有銷售 TEAS’ TEA 系列商品「蘋果紅茶」及「蜜桃紅茶」 因為果香配合茶香的 自然溫潤而受到消費者的喜愛。 TEAS’ TEA 系列商品今年還有新推出 「抹茶拿鐵」，濃厚牛奶配上甘甜抹茶， 令人回韻無窮。</p>
                
<!--
                <div class="p_box flex">
                        <img src="/family/img/pro-01.png">
                        <div class="con">
                            <div><big>伊藤園綠茶</big>530ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>100％使用日本國產茶葉。</li> 
                                <li>使用伊藤園獨家製法，忠實呈現與眾不同的「茶甜香 味」。</li> 
                                <li>「回甘茶香」的極致，百喝不膩的好茶。</li> 
                                <li>不添加任何香料，無調味，享受天然的美味。</li>
                            </ul>
                        </div>
                    </div>
-->
                
                <div class="slider">
                    <div class="p_box flex">
                        <img src="/family/img/pro-01.png">
                        <div class="con">
                            <div><big>伊藤園綠茶</big>530ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>100％使用日本國產茶葉。</li> 
                                <li>使用伊藤園獨家製法，忠實呈現與眾不同的「茶甜香 味」。</li> 
                                <li>「回甘茶香」的極致，百喝不膩的好茶。</li> 
                                <li>不添加任何香料，無調味，享受天然的美味。</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-02.png">
                        <div class="con">
                            <div><big>伊藤園濃味綠茶</big>530ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>100％使用日本國產茶葉。</li>
                                <li>使用伊藤園獨家製法，特別抑制苦味。</li>
                                <li>精粹濃郁的茶感。</li>
                                <li>不添加任何香料，無調味，享受天然的美味。</li>
                                <li>兒茶素含量1.7倍(與綠茶商品比較)</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-03.png">
                        <div class="con">
                            <div><big>伊藤園TEAS'TEA蘋果紅茶</big>530ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>台灣生產，日本品質！</li>
                                <li>不使用人工甜味劑。</li>
                                <li>香甜的富士蘋果與蘋果蜂蜜的完美結合。</li>
                                <li>保留蘋果的天然甜味</li>
                                <li>日本人氣TEAS'TEA系列茶飲。</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-04.png">
                        <div class="con">
                            <div><big>伊藤園TEAS'TEA蜜桃紅茶</big>530ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>台灣生產，日本品質！</li>
                                <li>不使用人工甜味劑。</li>
                                <li>白桃與紅桃的微甜合奏，清新爽口。</li>
                                <li>甜度降低，清爽無負擔</li>
                                <li>日本人氣TEAS'TEA系列茶飲。</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-05.png">
                        <div class="con">
                            <div><big>伊藤園TEAS'TEA抹茶拿鐵</big>500ml</div>
                            <div>賞味期限 12個月</div>
                            <ul class="list1">
                                <li>台灣生產，日本品質！</li>
                                <li>不使用人工甜味劑。</li>
                                <li>甘甜抹茶及濃厚牛奶的絕妙搭配！</li>
                                <li>添加日本產抹茶粉，回韻更香甜。</li>
                                <li>日本人氣TEAS'TEA系列茶飲。</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-06.png">
                        <div class="con">
                            <div><big>伊藤園金烏龍茶</big>500ml</div>
                            <div>賞味期限 9個月</div>
                            <ul class="list1">
                                <li>使用稀少品種-黃金桂、鐵觀音</li>
                                <li>有著將茶葉美味展現極致的優雅香氣以及醇厚的味道<br>
                                    **黃金桂擁有著桂花豐富的香氣、鐵觀音則擁有甜甜香氣以及清爽回甘滋味</li>
                                <li>無香料、無調味、自然原味</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-07.png">
                        <div class="con">
                            <div><big>伊藤園冷梅的實力(清涼飲料)</big>500g</div>
                            <div>賞味期限 9個月</div>
                            <ul class="list1">
                                <li>不使用香料，兼備了梅子原本的美味與健康！<br>
                                    (不使用香料，而是只用「梅子」相關原料來呈現自然又好
                                    吃的味道！)</li>
                                <li>蜂蜜使它帯點些微地甜美、天然水使它更加清爽</li>
                                <li>使用日本第一生產量、和歌山縣產的「南高梅」</li>
                                <li>含有可預防中暑的成分「檸檬酸」</li>
                            </ul>
                        </div>
                    </div>
                    <div class="p_box flex">
                        <img src="/family/img/pro-08.png">
                        <div class="con">
                            <div><big>京都宇治抹茶綠茶(冷泡版)</big>525ml</div>
                            <div>賞味期限 9個月</div>
                            <ul class="list1">
                                <li>可享受到豐厚地香甜美味、鮮艷的茶色</li>
                                <li>使用京都宇治抹茶。顏色鮮活且味道溫和美味</li>
                                <li>用獨特的「冰水冷泡法」，抑制茶的苦味和澀味，引出茶本身的甜味！</li>
                                <li>新瓶型好拿又有設計感！</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <img src="/family/img/pro-bg-01.jpg" class="full">
        </div>
        <div id="prize" class="bg2">
            <div class="box1">
                <h2><img src="/family/img/tit-03.png" class="full"></h2>
                <div class="flex">
                    <img src="/family/img/a-01.png" class="fleft">
                    <h4 class="fleft">沖繩來回雙人經濟艙機票 1 組(2 名) </h4>
                </div>
                <table class="table1">
                    <thead>
                        <tr>
                            <th>姓名</th>
                            <th>手機號碼</th>
                            <th>發票號碼</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                    </tbody>
                </table>
                <div class="flex">
                    <img src="/family/img/a-02.png" class="fleft">
                    <h4 class="fleft">伊藤園商品五箱 (24瓶/箱) 5 名 </h4>
                </div>
                <table class="table1">
                    <thead>
                        <tr>
                            <th>姓名</th>
                            <th>手機號碼</th>
                            <th>發票號碼</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                    </tbody>
                </table>
                <div class="flex">
                    <img src="/family/img/a-03.png" class="fleft">
                    <h4 class="fleft">伊藤園商品一箱 (24 瓶/箱) 20 名</h4>
                </div>
                <table class="table1">
                    <thead>
                        <tr>
                            <th>姓名</th>
                            <th>手機號碼</th>
                            <th>發票號碼</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                        <tr>
                            <td>王 O 明</td>
                            <td>0912-456-XXX</td>
                            <td>AX–12345678</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">
    <link rel="stylesheet" type="text/css" href="/family/css/slick.css">
    <link rel="stylesheet" type="text/css" href="/family/css/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="/family/css/jquery.mCustomScrollbar.css">
    <script src="/js/plugins/sweetalert.min.js"></script>
    <script type="text/javascript" src="/family/js/slick.min.js"></script>
    <script type="text/javascript" src="/family/js/jquery.mCustomScrollbar.concat.min.js"></script>
    <script type="text/javascript">
        $(function() {
            // slider
            $('.slider').slick({
                arrows: true
            });
            $(".con").mCustomScrollbar({
                scrollButtons:{enable:true},
				theme:"light-thick",
				scrollbarPosition:"inside"
            });

            // add receipt
            $('.add span').click(function() {
                var add = $(this).parent();
                var copy = add.clone(true);
                copy.find('input').val('');
                copy.insertBefore($('.ps'));
            });
        });
function del(id, check) {
    $('input[id=name]').val('');
    $('input[id=phone]').val('');
    $('input[id=text]').val('');
    $('input[id=email]').val('');
}

function done(){
    swal({
        title: "",
        text: '活動已截止!',
        type: "success"
    });
}

function submit(id, check) {

    if($('input[id=text]').val().length === 0){
        swal({
            title: "錯誤",
            text:'請填寫發票號碼',
            type:'warning'
        });
        return false;
    }
    if($('input[id=text]').val().includes("-") == false){
        swal({
            title: "錯誤",
            text:'發票號碼格式錯誤(請注意"-")',
            type:'warning'
        });
        return false;
    }
    var text = $('input[id=text]').val().split("-");
    if($('input[id=text]').val().length != 11 || text[0].length !=2 || text[1].length != 8){
        swal({
            title: "錯誤",
            text:'發票號碼格式錯誤',
            type:'warning'
        });
        return false;
    }
    if($('input[id=name]').val().length === 0){
        swal({
            title: "錯誤",
            text:'請填寫姓名',
            type:'warning'
        });
        return false;
    }
    if($('input[id=email]').val().length === 0){
        swal({
            title: "錯誤",
            text:'請填寫信箱',
            type:'warning'
        });
        return false;
    }
    if($('input[id=phone]').val().length === 0 ){
        swal({
            title: "錯誤",
            text:'請填寫聯絡電話',
            type:'warning'
        });
        return false;
    }
    if($('input[id=phone]').val().length < 8 || $('input[id=phone]').val().length > 10){
        swal({
            title: "錯誤",
            text:'電話格式錯誤',
            type:'warning'
        });
        return false;
    }
    var phone_re = /[0-9]/;
    if(phone_re.test($('input[id=phone]').val()) != true){
        swal({
            title: "WARNING",
            text: '電話不為數字',
            type: "warning"
        });
        return false;
    }

    if(document.getElementById('contact1').checked != true ){
        swal({
            title: "錯誤",
            text:'請勾選資料皆為正確內容 (請填寫正確以利後續兌獎確認)。',
            type:'warning'
        });
        return false;
    }

    if (document.getElementById('contact2').checked != true) {
        swal({
            title: "錯誤",
            text:'請勾選我已詳閱活動辦法及注意事項說明',
            type:'warning'
        });
        return false;
    }
    $.ajax({
        url: "family_submit",
        type: "POST",
        data: {
            _method: "POST",
            _token: $('#token').val(),
            name: $('#name').val(),
            text: $('#text').val(),
            phone: $('#phone').val(),
            email: $('#email').val(),
        },
        dataType: "json",
    }).done(function(r){
        if( r.status==0 ) {
            swal({
                type: 'success',
                text: '成功',
            }).then(function() {
                location.href = "http://www.okinawaitoen.com.tw/2017familymart";
            });
        } else {
            if( "email" in r.errors ){
                swal({
                    title: "失敗",
                    text: 'Email格式錯誤!',
                    type: "error"
                });
                return false;
            }
            if( "text" in r.errors ){
                swal({
                    title: "失敗",
                    text: '此發票已登入抽獎!',
                    type: "error"
                });
                return false;
            }
                
        }
    });
}
    </script>
</body>

</html>