

<?php $__env->startSection("content"); ?>
<div class="sixteen wide column">
    <h1 class="ui header">
        參加者資料
    </h1>
    <div class="ui divider"></div>
    <?php if( !count($list) ): ?>  
    <h1 class="ui grey header">
        <i class="warning icon"></i>
        <div class="content">沒有資料</div>
    </h1>
    <?php else: ?>
    <table id="activity_table" class="ui unstackable table">
        <thead>
            <tr>
                <th>發票號碼</th>
                <th>姓名</th>
                <th>手機號碼</th>
                <th>電子信箱</th>
                <th>時間</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($list as $v): ?> 
            <tr>
                <td><p><?php echo e($v->text); ?></p></td>
                <td><p><?php echo e($v->name); ?></p></td>
                <td><p><?php echo e($v->cellphhone); ?></p></td>
                <td><?php echo e($v->email); ?></td>
                <td><?php echo e($v->created_at); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php endif; ?>
    
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>


<script type="text/javascript">
    
    <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
$(document).ready( function () {
    $('#activity_table').DataTable({
        "pageLength": 10,
        "lengthChange": false,
        "language": {
            "search": "search the key:",
            "searchPlaceholder": "Search",
            "zeroRecords": "找不到相對應的值，請重新輸入",
            "info": "第 _START_ 到 _END_ 筆，共 _TOTAL_ 筆",
            "infoFiltered": ""

    },
        "order": [[ 1, 'desc' ]]

    });
    var table = $('#activity_table').DataTable();

} );

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('sales.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>