<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <meta name="csrf_token" content="<?php echo e(csrf_token()); ?>" />
    <link rel="icon" sizes="96x96" href="<?php echo e(url('images/favicon.png')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(url('images/favicon.png')); ?>">
    <title>電池協會</title>
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta property="og:url" content="<?php echo e(url('/')); ?>" />
    <meta property="og:image" content="<?php echo e(url('/')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('css/semantic.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/pickadate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/client.css')); ?>">
    <?php echo $__env->yieldContent('head'); ?>
</head>
<body>
    <header>
    <div class="ui grid">
        <?php echo $__env->make("client.layouts.nav", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    </header>
    <main>
        <div class="ui content">
        <?php echo $__env->yieldContent("content"); ?>
        </div>
    </main>
    <footer>
        <div class="ui grid">
            <div class="column" style="background:#6b6b6b !important">
                <div class="right floated">
                    <b>Version</b> 1.0.0
                </div>
                <strong>Copyright © 2016 <a>xxxxxxxxxx Studio</a>.</strong> All rights reserved.
            </div>
        </div>
    </footer>
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('js/client.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function(){
          $('.right.menu.open').on("click",function(e){
            e.preventDefault();
            $('.ui.vertical.menu').toggle();
          });
            
          $('.ui.dropdown').dropdown();
        });
    </script>
    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>
