<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Func;

class FuncController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        return view("sales.func.list", [ "list"=>Func::whereNull("parent_id")->orderBy('id')->orderBy('sort')->get() ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('sales.func.create', ['opts'=>$this->options()]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $v = $this->validate($request, [
            'name' => 'required|max:20',
            'slug' => 'required|max:20|unique:funcs',
        ]);

        $r = Func::create([
            "name" => $request->input("name"),
            "slug" => snake_case($request->input("slug"),"_"),
            "divider" => $request->has("divider"),
            "parent_id" => $request->has("parent")?$request->input("parent"):null,
        ]);

        if($r) {
            return redirect('/func')->withMessage("新增功能 <b>".$request->input("name")."</b> 成功");
        } else {
            return redirect()->back()->withMessage($r);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Func $func)
    {
        //
        return view('sales.func.edit', compact('func'), ['opts'=>$this->options()]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Func $func)
    {
        //
        if( $request->ajax() ) {
            $func->sort = $request->input("sort");
            return response()->json($func->save());
        }

        $v = $this->validate($request, [
            'name' => 'required|max:20',
            'slug' => 'required|max:20'
        ]);

        $func->name = $request->input("name");
        $func->slug = snake_case($request->input("slug"),"_");
        $func->divider = $request->has("divider");
        $func->parent_id = $request->has("parent")?$request->input("parent"):null;

        if( $func->save() ) {
            return redirect('/func')->withMessage("功能 <b>".$request->input("name")."</b> 儲存成功");
        } else {
            return redirect()->back()->withMessage($func->save());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Func $func)
    {
        //
        if(count($func->child()) && !$func->child()->delete())
            return response()->json(0);

        return response()->json($func->delete());
    }

    private function options($value='')
    {
        // dd(Func::whereParentId(null)->lists('name','id'));
        return Func::whereParentId(null)->lists('name','id');
    }
}
