<?php

namespace App\Http\Controllers\ClientAuth;

use Auth;
use Session;
use Validator;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Models\Domain;
use App\Models\Client;

class AuthController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Registration & Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users, as well as the
    | authentication of existing users. By default, this controller uses
    | a simple trait to add these behaviors. Why don't you explore it?
    |
    */

    use AuthenticatesAndRegistersUsers, ThrottlesLogins;

    /**
     * Where to redirect users after login / registration.
     *
     * @var string
     */
    protected $guard = 'client';
    protected $redirectTo = '/';
    protected $redirectAfterLogout = '/login';

    /**
     * Create a new authentication controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware($this->guestMiddleware(), ['except' => 'logout']);
    }

    // 登入畫面
    public function getLogin()
    {
        return view("client.auth.login");
    }

    // 登入驗證
    public function postLogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
            'captcha' => 'required|captcha'
        ]);
        $check = 0;
        $domain_id = Domain::where('domain_name',$request->server('HTTP_HOST'))->first()->id;
        $client = Client::where('email',$request->input('email'))->get();
        foreach ($client as $key => $value) {
            if($value->domain_id != $domain_id){
                $check = 0;
            }else{
                $client_id = $value->id;
                $provider_id = $value->provider_id;
                $check = 1; break;
            }
        }
        if($check == 1){
            if($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }
            
            if (Auth::guard($this->guard)->attempt(
                [ 'email' => $request->input("email"), 'password' => $request->input("password"),'id' => $client_id , 'provider_id' => $provider_id], 
                $request->has("remember") )
            ) {
                return redirect('/');
            } else {
                return redirect()->back()->withErrors("帳號密碼錯誤")->withInput();
            }
        }else{
            return redirect()->back()->withErrors("帳號密碼錯誤")->withInput();
        }

    }

    // 登出
    public function logout()
    {   
        Auth::guard($this->guard)->logout();
        Session::flush();
        return redirect('/');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return User
     */
    protected function create(array $data)
    {
        return Sales::create([
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
        ]);
    }
}
