<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\Data1;
use App\Models\Data2;
use App\Models\Data3;
use App\Models\Data4;
use App\Models\Data5;
use Validator;
use Auth;
use Response;
use Excel;
use PHPExcel_Style_NumberFormat;

class DashboardController extends Controller
{
    //
    public function admin(Request $request)
    {
        return view('admin.dashboard');
    }
    //
    public function sales(Request $request)
    {
        $sales = Auth::guard('sales')->user();
        return view('sales.dashboard');
    }

    //導向
    public function index(Request $request)
    {
        return view('client.index');
    }

    //導向
    public function p1(Request $request)
    {
        return view('client.p1');
    }

    public function p2(Request $request)
    {
        return view('client.p2');
    }

    public function p3(Request $request)
    {
        return view('client.p3');
    }

    public function p4(Request $request)
    {
        return view('client.p4');
    }

    public function p5(Request $request)
    {
        return view('client.p5');
    }
    public function ptest(Request $request)
    {
        return view('client.ptest');
    }

    public function p1_submit(Request $request)
    {
        $check = Data1::where("email",$request->input("email"))->first();
        if($check != null){
            return response()->json([
                'status' => 1,
                ]);
        }
        $check2 = Data1::where("mobile",$request->input("mobile"))->first();
        if($check2 != null){
            return response()->json([
                'status' => 2,
                ]);
        }



        $active = new Data1;
        $active->lastname = $request->input("lastname");
        $active->firstname = $request->input("firstname");
        $active->mobile = $request->input("mobile");
        $active->email = $request->input("email");
        $active->address = $request->input("address");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }

    public function p2_submit(Request $request)
    {
        $check = Data2::where("email",$request->input("email"))->first();
        if($check != null){
            return response()->json([
                'status' => 1,
                ]);
        }
        $check2 = Data2::where("mobile",$request->input("mobile"))->first();
        if($check2 != null){
            return response()->json([
                'status' => 2,
                ]);
        }


        $active = new Data2;
        $active->lastname = $request->input("lastname");
        $active->firstname = $request->input("firstname");
        $active->mobile = $request->input("mobile");
        $active->email = $request->input("email");
        $active->address = $request->input("address");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }

    public function p3_submit(Request $request)
    {
        $check = Data3::where("email",$request->input("email"))->first();
        if($check != null){
            return response()->json([
                'status' => 1,
                ]);
        }
        $check2 = Data3::where("mobile",$request->input("mobile"))->first();
        if($check2 != null){
            return response()->json([
                'status' => 2,
                ]);
        }


        $active = new Data3;
        $active->lastname = $request->input("lastname");
        $active->firstname = $request->input("firstname");
        $active->mobile = $request->input("mobile");
        $active->email = $request->input("email");
        $active->address = $request->input("address");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }

    public function p4_submit(Request $request)
    {
        $check = Data4::where("email",$request->input("email"))->first();
        if($check != null){
            return response()->json([
                'status' => 1,
                ]);
        }
        $check2 = Data4::where("mobile",$request->input("mobile"))->first();
        if($check2 != null){
            return response()->json([
                'status' => 2,
                ]);
        }


        $active = new Data4;
        $active->lastname = $request->input("lastname");
        $active->firstname = $request->input("firstname");
        $active->mobile = $request->input("mobile");
        $active->email = $request->input("email");
        $active->address = $request->input("address");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }

    public function p5_submit(Request $request)
    {
        $check = Data5::where("email",$request->input("email"))->first();
        if($check != null){
            return response()->json([
                'status' => 1,
                ]);
        }
        $check2 = Data5::where("mobile",$request->input("mobile"))->first();
        if($check2 != null){
            return response()->json([
                'status' => 2,
                ]);
        }


        $active = new Data5;
        $active->lastname = $request->input("lastname");
        $active->firstname = $request->input("firstname");
        $active->mobile = $request->input("mobile");
        $active->email = $request->input("email");
        $active->address = $request->input("address");
        $active->save();

        return response()->json([
            'status' => 0,
            ]);
    }


    //活動一
    public function p1_info()
    {
        $info = Data1::all();
        return view('sales.info',[
            "list"=>$info,
            "title"=>"p1"
        ]);
    }
    public function p1_excel()
    {   
        Excel::create('p1', function($excel) {
            $excel->sheet('p1', function($sheet) {
                $data = Data1::orderBy('created_at','asc')->get();
                $sheet->row(1, array('姓氏','名字','手機號碼','電子信箱','地址','同意條款','建立時間'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                    'E'     =>  30,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->lastname, $v->firstname, $v->mobile, $v->email, $v->address,'V',$v->created_at));
                }
            });
        })->export('xls');
    }


    //活動一
    public function p2_info()
    {
        $info = Data2::all();
        return view('sales.info',[
            "list"=>$info,
            "title"=>"p2"
        ]);
    }
    public function p2_excel()
    {   
        Excel::create('p2', function($excel) {
            $excel->sheet('p2', function($sheet) {
                $data = Data2::orderBy('created_at','asc')->get();
                $sheet->row(1, array('姓氏','名字','手機號碼','電子信箱','地址','同意條款','建立時間'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                    'E'     =>  30,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->lastname, $v->firstname, $v->mobile, $v->email, $v->address,'V',$v->created_at));
                }
            });
        })->export('xls');
    }


    //活動一
    public function p3_info()
    {
        $info = Data3::all();
        return view('sales.info',[
            "list"=>$info,
            "title"=>"p3"
        ]);
    }
    public function p3_excel()
    {   
        Excel::create('p3', function($excel) {
            $excel->sheet('p3', function($sheet) {
                $data = Data3::orderBy('created_at','asc')->get();
                $sheet->row(1, array('姓氏','名字','手機號碼','電子信箱','地址','同意條款','建立時間'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                    'E'     =>  30,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->lastname, $v->firstname, $v->mobile, $v->email, $v->address,'V',$v->created_at));
                }
            });
        })->export('xls');
    }


    //活動一
    public function p4_info()
    {
        $info = Data4::all();
        return view('sales.info',[
            "list"=>$info,
            "title"=>"p4"
        ]);
    }
    public function p4_excel()
    {   
        Excel::create('p4', function($excel) {
            $excel->sheet('p4', function($sheet) {
                $data = Data4::orderBy('created_at','asc')->get();
                $sheet->row(1, array('姓氏','名字','手機號碼','電子信箱','地址','同意條款','建立時間'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                    'E'     =>  30,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->lastname, $v->firstname, $v->mobile, $v->email, $v->address,'V',$v->created_at));
                }
            });
        })->export('xls');
    }


    //活動一
    public function p5_info()
    {
        $info = Data5::all();
        return view('sales.info',[
            "list"=>$info,
            "title"=>"p5"
        ]);
    }
    public function p5_excel()
    {   
        Excel::create('p5', function($excel) {
            $excel->sheet('p5', function($sheet) {
                $data = Data5::orderBy('created_at','asc')->get();
                $sheet->row(1, array('姓氏','名字','手機號碼','電子信箱','地址','同意條款','建立時間'));
                $sheet->freezeFirstRow();
                $sheet->setWidth(array(
                    'A'     =>  15,
                    'B'     =>  15,
                    'C'     =>  15,
                    'D'     =>  20,
                    'E'     =>  30,
                ));
                foreach ($data as $k => $v) {

                    $sheet->appendRow(array($v->lastname, $v->firstname, $v->mobile, $v->email, $v->address,'V',$v->created_at));
                }
            });
        })->export('xls');
    }



}
