<?php

namespace App\Http\Middleware;

use Closure;
use Session;
use Illuminate\Support\Facades\Auth;

class Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->guest()) {
            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            }

            return redirect()->guest('/manager/login');
        }
        if( Auth::user()->id!=1 && !is_null($request->segment(2)) && !in_array($request->segment(1).'/'.$request->segment(2), Session::get('permission') ) ) {
            return redirect('/manager');
        }

        return $next($request);
    }
}
