<?php
// 帶入各個 router 所需的基本資料
View::composers([
    'App\Http\ViewComposers\AdminComposer' => "*",
    ]);



/**
 * 店家前台
 */
Route::get("/", 'DashboardController@index'); //導向
Route::get("p1", 'DashboardController@p1'); //導向
Route::get("p2", 'DashboardController@p2'); //導向
Route::get("p3", 'DashboardController@p3'); //導向
Route::get("p4", 'DashboardController@p4'); //導向
Route::get("p5", 'DashboardController@p5'); //導向
Route::get("ptest", 'DashboardController@ptest'); //導向

Route::post("p1/submit", 'DashboardController@p1_submit'); //導向
Route::post("p2/submit", 'DashboardController@p2_submit'); //導向
Route::post("p3/submit", 'DashboardController@p3_submit'); //導向
Route::post("p4/submit", 'DashboardController@p4_submit'); //導向
Route::post("p5/submit", 'DashboardController@p5_submit'); //導向



Route::post("captcha", 'DashboardController@captcha'); //導向



Route::group(['prefix' => 'manager'], function() {
    Route::get('login', 'Auth\AuthController@getLogin');
    Route::post('login', 'Auth\AuthController@postLogin');
    Route::get('logout', 'Auth\AuthController@logout');
    // 登入審核
    Route::group(['middleware' => 'auth'], function() {
        Route::get("/", 'DashboardController@sales');

        Route::get("p1_info", 'DashboardController@p1_info');
        Route::get("p1_excel", 'DashboardController@p1_excel');

        Route::get("p2_info", 'DashboardController@p2_info');
        Route::get("p2_excel", 'DashboardController@p2_excel');

        Route::get("p3_info", 'DashboardController@p3_info');
        Route::get("p3_excel", 'DashboardController@p3_excel');

        Route::get("p4_info", 'DashboardController@p4_info');
        Route::get("p4_excel", 'DashboardController@p4_excel');

        Route::get("p5_info", 'DashboardController@p5_info');
        Route::get("p5_excel", 'DashboardController@p5_excel');

    });
});