<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;

use Carbon\Carbon;
use App\Models\Mt4ProjectLevel;
use App\Models\GrantProjectLevel;
use App\Models\Mt4ProjectResult;
use App\Models\GrantProjectResult;
use App\Models\SalesWithdrawal;
use App\Models\Client;

class Sales extends Authenticatable
{
    //
    public $timestamps = true;
    protected $guarded = ['id'];

    protected $fillable = [
        'domain_group_id','email', 'password','is_checked','noob_teach',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];
    public function sales_detail() {
        return $this->hasOne('App\Models\SalesDetail','sale_id');
    }
    
    public function domain_group() {
        return $this->belongsTo('App\Models\DomainGroup');
    }
}
