<?php

namespace App;

use Laravel\Socialite\Contracts\User as ProviderUser;

use Illuminate\Http\Request;
use App\Http\Requests;

use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;

use App\Models\SocialClient;
use App\Models\Client;
use App\Models\ClientDetail;
use App\Models\Domain;
use App\Models\ClientType;
use Auth;

class SocialAccountService
{
    use AuthenticatesAndRegistersUsers, ThrottlesLogins;

    protected $guard = 'client';

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function createOrGetUser(ProviderUser $providerUser)
    {
        $domain_id = Domain::where('domain_name',$this->request->server('HTTP_HOST'))->first()->id;
        $client_type = ClientType::where('domain_id',$domain_id)->first();
        $check = 0;
        if($providerUser->getEmail() != null){
            $client = Client::where('domain_id',$domain_id)->where('provider_id',2)->where('email',$providerUser->getEmail())->first();
        }else{
             $client = Client::where('domain_id',$domain_id)->where('provider_id',2)->where('email',$providerUser->getId())->first();
        }
        if( $client != null ){
            $check = 1;
        }
        if ($check == 1) {
            if($providerUser->getEmail() == null){
                if (Auth::guard($this->guard)->attempt(
                    [ 'email' =>$providerUser->getId(),'password' => 'facebook_provider' ,'id' => $client->id , 'provider_id' => $client->provider_id],
                    $this->request->has("remember") )
                ){
                    return 0;
                }
            }else{
                if (Auth::guard($this->guard)->attempt(
                    [ 'email' =>$providerUser->getEmail(),'password' => 'facebook_provider' ,'id' => $client->id , 'provider_id' => $client->provider_id],
                    $this->request->has("remember") )
                ){
                    return 0;
                }
            }
        } else {
            if($providerUser->getEmail() == null){
                $client = Client::create([
                    'client_type_id' => $client_type->id,
                    'domain_id' => $domain_id,
                    'provider_id' => 2,
                    'email' => $providerUser->getId(),
                    'password' => bcrypt('facebook_provider')
                    ]);
                $client_detail = new ClientDetail([
                    'name' => $providerUser->getName()
                    ]);
                $client->client_detail()->save($client_detail);
                if (Auth::guard($this->guard)->attempt(
                    [ 'email' => $providerUser->getId(),'password' => 'facebook_provider' ,'id' => $client->id , 'provider_id' => $client->provider_id], 
                    $this->request->has("remember") )
                ){
                $user = Auth::user();
                return $client;
                }
            }else{
                $client = Client::create([
                    'client_type_id' => $client_type->id,
                    'domain_id' => $domain_id,
                    'provider_id' => 2,
                    'email' => $providerUser->getEmail(),
                    'password' => bcrypt('facebook_provider')
                    ]);
                $client_detail = new ClientDetail([
                    'name' => $providerUser->getName(),
                    'email' => $providerUser->getEmail()
                    ]);
                $client->client_detail()->save($client_detail);
                if (Auth::guard($this->guard)->attempt(
                    [ 'email' => $providerUser->getEmail(),'password' => 'facebook_provider' ,'id' => $client->id , 'provider_id' => $client->provider_id], 
                    $this->request->has("remember") )
                ){
                $user = Auth::user();
                return $client;
                }
            }
            
        }

    }
}