<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("client_type_id")->unsigned()->comment("所屬分類");
            $table->string('email', 120)->comment('登入帳號兼email');
            $table->string('password', 120);
            $table->rememberToken();
            $table->timestamps();
        });
        
        Schema::table('clients', function (Blueprint $table) {
            $table->index(['email']);
            $table->foreign('client_type_id')->references('id')->on('client_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clients', function(Blueprint $table){
            $table->dropIndex(['email']);
            $table->dropForeign('clients_client_type_id_foreign');
        }); 

        Schema::drop('clients');
    }
}
