<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGroupPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('group_permissions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('group_id')->unsigned()->comment("所屬群組");
            $table->integer('func_id')->unsigned()->comment("所屬功能");
            $table->integer('permission')->default(0)->comment("0: 無權限, 1: 可瀏覽, 2: 可編輯");
        });

        Schema::table('group_permissions', function (Blueprint $table) {
            $table->foreign('group_id')->references('id')->on('groups');
            $table->foreign('func_id')->references('id')->on('funcs');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('group_permissions', function(Blueprint $table){
            $table->dropForeign('group_permissions_group_id_foreign');
            $table->dropForeign('group_permissions_func_id_foreign');
        }); 

        Schema::drop('group_permissions');
    }
}
