<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <meta name="csrf_token" content="{{ csrf_token() }}" />
    <link rel="icon" sizes="96x96" href="{{ url('images/favicon.png') }}">
    <link rel="apple-touch-icon" href="{{ url('images/favicon.png') }}">
    <title>國際特赦組織</title>
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta property="og:url" content="{{ url('/') }}" />
    <meta property="og:image" content="{{ url('/') }}" />
    <link rel="stylesheet" href="{{ asset('css/semantic.css') }}">
    <link rel="stylesheet" href="{{ asset('css/pickadate.css') }}">
    <link rel="stylesheet" href="{{ asset('css/client.css') }}">
    @yield('head')
</head>
<body>
    <header>
    <div class="ui grid">
        @include("client.layouts.nav")
    </div>
    </header>
    <main>
        <div class="ui content">
        @yield("content")
        </div>
    </main>
    <footer>
        <div class="ui grid">
            <div class="column" style="background:#6b6b6b !important">
                <div class="right floated">
                    <b>Version</b> 1.0.0
                </div>
                <strong>Copyright © 2016 <a>xxxxxxxxxx Studio</a>.</strong> All rights reserved.
            </div>
        </div>
    </footer>
    <script src="{{ asset('js/main.js') }}"></script>
    <script src="{{ asset('js/client.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function(){
          $('.right.menu.open').on("click",function(e){
            e.preventDefault();
            $('.ui.vertical.menu').toggle();
          });
            
          $('.ui.dropdown').dropdown();
        });
    </script>
    @yield('script')
</body>
</html>
