@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        功能管理 
        <a href="{{ url('/func/create') }}" class="ui green small button">
            <i class="plus icon"></i> 新增功能
        </a>
    </h1>
    <div class="ui divider"></div>
    @if( !count($list) )  
    <h1 class="ui grey header">
        <i class="warning icon"></i>
        <div class="content">沒有功能</div>
    </h1>
    @endif
    <div id="func-accordion" class="ui accordion list">
    @foreach($list as $v)  
        <div class="item" id="func-{{ $v->id }}">
            <div class="title">
                @if( count($v->child()) )
                <i class="dropdown icon"></i>
                @else
                <i class="icon"></i>
                @endif
                <span>{{ $v->name }} / {{ $v->slug }}</span>
                <div class="right floated">
                    <div class="ui labeled small input">
                        <div class="ui label">排序</div>
                        <input type="text" name="sort" value="{{ $v->sort }}" onchange="updateSort(this,{{ $v->id }});">
                    </div>
                    <a href="{{ url('/func/'.$v->id.'/edit') }}" class="ui icon small orange button"><i class="pencil icon"></i></a>
                    <a onclick="notification('func', {{ $v->id }})" class="ui icon small red button"><i class="trash icon"></i></a>
                </div>
            </div>
            @if( count($v->child()) )
            <div class="content">
                @foreach($v->child() as $c)
                    <div class="title" id="func-{{ $c->id }}">
                        <!-- <i class="dropdown icon"></i> -->
                        <span>{{ $c->name }} / {{ $c->slug }}</span>
                        <div class="right floated">
                            <div class="ui labeled small input">
                                <div class="ui label">排序</div>
                                <input type="text" name="sort" value="{{ $c->sort }}" onchange="updateSort(this,{{ $c->id }});">
                            </div>
                            <a href="{{ url('/func/'.$c->id.'/edit') }}" class="ui icon small orange button"><i class="pencil icon"></i></a>
                            <a onclick="notification('func', {{ $c->id }})" class="ui icon small red button"><i class="trash icon"></i></a>
                        </div>
                    </div>
                @endforeach
            </div>
            @endif
        </div>
    @endforeach
    </div>
</div>
@endsection

@section("script")
<script type="text/javascript">
    
    @include('partials.message')

    function notification(type, id) {
        if( confirm("刪除可能會影響到下層功能，是否確認刪除？") ) {
            deleteItem(type, id);
        }
    }
    $("#func-accordion").accordion({
        selector: {
          trigger: '.title .icon'
        }
    });


    function updateSort(tag, id) {
        var val = tag.value;
        $.ajax({
            url: host+"/func/"+id,
            method: "PUT",
            data: { 
                _token: $('meta[name="csrf_token"]').attr('content'),
                _method: "PUT",
                sort: val
            },
            dataType: "json",
            beforeSend: function (argument) {
                // body...
            }
        }).done(function(r){
            if( r ) {
                $(".ui.message").html("<b>排序修改成功</b>").slideDown();
            } else {
                $(".ui.message").html("<b>排序修改失敗</b>").slideDown();
            }
            hideMessage();
        });
    }
</script>
@endsection