@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        編輯角色
    </h1>
    <div class="ui divider"></div>
    <form method="post" action="{{ url('/group/'.$group->id) }}" class="ui form">
        {{ csrf_field() }}
        {{ method_field("PUT") }}
        <div class="field">
            <label for="name">角色名稱</label>
            <input type="text" name="name" id="name" value="{{ $group->name }}">
        </div>
        <h4 class="ui header dividing">
            權限設定
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-2" value="2">
                <label>全部可編輯</label>
            </div>
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-1" value="1">
                <label>全部可瀏覽</label>
            </div>
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-0" value="0">
                <label>無權限</label>
            </div>
        </h4>
        @foreach($navs as $f)
        <div class="field">
            <label>{{ $f->name }}</label>
            <div class="field">
                @if(count($group->permissions))
                @foreach($group->permissions as $p )
                @if( $p->func_id == $f->id)
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="0" @if($p->permission==0) checked @endif />
                    <label>無權限</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="1" @if($p->permission==1) checked @endif />
                    <label>瀏覽</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="2" @if($p->permission==2) checked @endif />
                    <label>編輯</label>
                </div>
                @endif
                @endforeach
                @else
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="0"/>
                    <label>無權限</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="1"/>
                    <label>瀏覽</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[{{ $f->id }}]" value="2"/>
                    <label>編輯</label>
                </div>
                @endif
            </div>
        </div>
        @if( count($f->child()) )
        <div class="fields child">
            <i class="arrow right icon"></i>
            @foreach($f->child() as $c)
            <div class="field">
                <label>{{ $c->name }}</label>
                <div class="field">
                    @if(count($group->permissions))
                    @foreach($group->permissions as $p )
                    @if( $p->func_id == $c->id)
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" @if($p->permission==0) checked @endif value="0">
                        <label>無權限</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" @if($p->permission==1) checked @endif value="1">
                        <label>瀏覽</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" @if($p->permission==2) checked @endif value="2">
                        <label>編輯</label>
                    </div>
                    @endif
                    @endforeach
                    @else
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" value="0">
                        <label>無權限</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" value="1">
                        <label>瀏覽</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[{{ $c->id }}]" value="2">
                        <label>編輯</label>
                    </div>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
        @endif
        <div class="ui divider"></div>
        @endforeach
        @if (count($errors) > 0)
        @include('partials.error', ['errors'=>$errors])
        @endif
        <div class="field center aligned">
            @if($editable)
            <button type="submit" class="ui green icon button">
                <i class="check icon"></i> 儲存角色
            </button>
            @endif
            <a href="javascript:window.history.back();" class="ui icon button">
                <i class="arrow left icon"></i> 取消，回上頁
            </a>
        </div>
    </form>
</div>
@endsection

@section("script")
<script type="text/javascript">

    $("input[name='check-all']").change(function() {
        $("input[name*='func_id'][value='"+this.value+"']").each(function(){
            this.checked = true;
        });
    });

    $('input[name*=func_id]').change(function(){
        var fields = $(this).parents('.field');
        if(fields.length == 2){
            if($(fields[1].nextElementSibling).hasClass('child')){
                $(fields[1].nextElementSibling).find('input[name*=func_id][value='+this.value+']').each(function(){
                    this.checked = true;
                });
            }
        }
    });
</script>
@endsection
