<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
    <meta name="csrf_token" content="{{ csrf_token() }}" />
    <title>protecttheprotest</title>
    <meta name="keywords" content="">
    <meta name="description" content="">
    <link rel="stylesheet" href="{{ asset('css/semantic.css') }}">
    <link rel="stylesheet" href="{{ asset('css/pickadate.css') }}">
    <link rel="stylesheet" href="{{ asset('css/sales.css') }}">
</head>
<body>
    @include("sales.layouts.sidebar")
    <div class="pusher">
        <header>
            <div class="ui grid">
                <div class="row">
                    <div class="ui secondary pointing inverted menu">
                        <a href="javascript:void(0);" class="item" id="sidebar-trigger">
                            <i class="content icon"></i>
                        </a>
                        <div class="item">您好，{{ Auth::user()->name  }}</div>
                        <div class="right menu">
                            <a href="{{ url('/manager/logout') }}" class="item">
                                登出 <i class="sign out icon"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <main>
            <div class="ui grid">
            @yield("content")
            </div>
        </main>
        <footer>
            <div class="ui grid">
                <div class="column">
                    <div class="right floated">
                        <b>Version</b> 1.0.0
                    </div>
                    <strong>Copyright © 2017 <a>protecttheprotest Studio</a>.</strong> All rights reserved.
                </div>
            </div>
        </footer>
    </div>
    <script src="{{ asset('js/main.js') }}"></script>
    <script src="{{ asset('js/admin.js') }}"></script>
    <script src="{{ asset('js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('js/dataTables.semanticui.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('ckeditor/ckeditor.js') }}"></script>
    <script type="text/javascript">
        $('#overview-tab .item').tab();
        function modal_show(){
            $('.large.modal').modal('show');
        }
        function modal_hide(){
            $('.large.modal').modal('hide');
        }
    </script>
    @yield('script')
</body>
</html>