@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        <a href="javascript:window.history.back();"><i class="arrow left icon"></i></a> 
        新增帳號
    </h1>
    <div class="ui divider"></div>
    <form method="POST" class="ui form" action="{{ url('/user') }}">
        {{ csrf_field() }}
        {{ method_field("POST") }}
        <div class="fields">
            <div class="field">
                <label for="name">姓名</label>
                <input type="text" name="name" id="name">
            </div>
            <div class="field">
                <label for="email">帳號</label>
                <input type="email" name="email" id="email">
            </div>
        </div>
        <div class="fields">
            <div class="field">
                <label for="password">密碼</label>
                <input type="password" name="password" id="password">
            </div>
            <div class="field">
                <label for="password_confirmation">確認密碼</label>
                <input type="password" name="password_confirmation" id="password_confirmation">
            </div>
        </div>
        <div class="fields">
            <div class="field">
                <label for="group_id">角色</label>
                <select name="group_id" id="group_id" class="ui selection dropdown">
                    <option value="">請選擇角色</option>
                    @foreach($opts as $k => $v)
                    <option value="{{$k}}">{{$v}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        @if (count($errors) > 0)
            @include('partials.error', ['errors'=>$errors])
        @endif
        <div class="ui divider"></div>
        <div class="field center aligned">
            @if($editable)
            <button type="submit" class="ui green icon button">
                <i class="check icon"></i> 儲存帳號
            </button>
            @endif
            <a href="javascript:window.history.back();" class="ui icon button">
                <i class="arrow left icon"></i> 取消，回上頁
            </a> 
        </div>
    </form>
</div>
@endsection