@extends('sales.layouts.app')

@section("content")
<div class="sixteen wide column">
    <h1 class="ui header">
        帳號管理 
        @if($editable)
        <a href="{{ url('/user/create') }}" class="ui green small button">
            <i class="plus icon"></i> 新增帳號
        </a>
        @endif
    </h1>
    <div class="ui divider"></div>
    <table id="user-table" class="ui very basic table">
        <thead>
            <tr>
                <th>帳號</th>
                <th>姓名</th>
                <th>更新日期</th>
                <th>創建日期</th>
                <th width="100"></th>
            </tr>
        </thead>
        <tbody>
        @if( !count($list) )  
            <tr>
                <td colspan="3">
                    <h1 class="ui grey center aligned header">
                        <i class="warning icon"></i>
                        <div class="content">沒有帳號</div>
                    </h1>
                </td>
            </tr>
        @endif
        @foreach($list as $v)
            <tr id="user-{{ $v->id }}">
                <td>{{ $v->email }}</td>
                <td>{{ $v->name }}</td>
                <td>{{ $v->updated_at }}</td>
                <td>{{ $v->created_at }}</td>
                <td class="right aligned">
                    <a href="{{ url('/user/'.$v->id.'/edit') }}" class="ui icon small orange button">
                        <i class="pencil icon"></i>
                    </a>
                    @if($editable && $v->id>2)
                    <a onclick="deleteItem('user', {{ $v->id }})" class="ui icon small red button">
                        <i class="trash icon"></i>
                    </a>
                    @endif
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endsection
@section("script")
<script type="text/javascript">
    @include('partials.message')

    $("#user-table").DataTable();
</script>
@stop
