

<?php $__env->startSection("content"); ?>
<div class="sixteen wide column">
    <h1 class="ui header">
        編輯角色
    </h1>
    <div class="ui divider"></div>
    <form method="post" action="<?php echo e(url('/group')); ?>" class="ui form">
        <?php echo e(csrf_field()); ?>

        <?php echo e(method_field("POST")); ?>

        <div class="field">
            <label for="name">角色名稱</label>
            <input type="text" name="name" id="name">
        </div>
        <h4 class="ui header dividing">
            權限設定
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-2" value="2">
                <label>全部可編輯</label>
            </div>
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-1" value="1">
                <label>全部可瀏覽</label>
            </div>
            <div class="ui radio checkbox right floated">
                <input type="radio" name="check-all" id="check-all-0" value="0">
                <label>無權限</label>
            </div>
        </h4>
        <?php foreach($navs as $f): ?>
        <div class="field">
            <label><?php echo e($f->name); ?></label>
            <div class="field">
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[<?php echo e($f->id); ?>]" value="0">
                    <label>無權限</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[<?php echo e($f->id); ?>]" value="1">
                    <label>瀏覽</label>
                </div>
                <div class="ui radio checkbox">
                    <input type="radio" name="func_id[<?php echo e($f->id); ?>]" value="2">
                    <label>編輯</label>
                </div>
            </div>
        </div>
        <?php if( count($f->child()) ): ?>
        <div class="fields child">
            <i class="arrow right icon"></i>
            <?php foreach($f->child() as $c): ?>
            <div class="field">
                <label><?php echo e($c->name); ?></label>
                <div class="field">
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[<?php echo e($c->id); ?>]" value="0">
                        <label>無權限</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[<?php echo e($c->id); ?>]" value="1">
                        <label>瀏覽</label>
                    </div>
                    <div class="ui radio checkbox">
                        <input type="radio" name="func_id[<?php echo e($c->id); ?>]" value="2">
                        <label>編輯</label>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <div class="ui divider"></div>
        <?php endforeach; ?>
        <?php if(count($errors) > 0): ?>
        <?php echo $__env->make('partials.error', ['errors'=>$errors], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php endif; ?>
        <div class="field center aligned">
            <?php if($editable): ?>
            <button type="submit" class="ui green icon button">
                <i class="check icon"></i> 儲存角色
            </button>
            <?php endif; ?>
            <a href="javascript:window.history.back();" class="ui icon button">
                <i class="arrow left icon"></i> 取消，回上頁
            </a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection("script"); ?>
<script type="text/javascript">

    $("input[name='check-all']").change(function() {
        $("input[name*='func_id'][value='"+this.value+"']").each(function(){
            this.checked = true;
        });
    });

    $('input[name*=func_id]').change(function(){
        var fields = $(this).parents('.field');
        if(fields.length == 2){
            if($(fields[1].nextElementSibling).hasClass('child')){
                $(fields[1].nextElementSibling).find('input[name*=func_id][value='+this.value+']').each(function(){
                    this.checked = true;
                });
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('sales.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>