

<?php $__env->startSection("content"); ?>
<div class="sixteen wide column">
    <h1 class="ui header">
        帳號管理 
        <?php if($editable): ?>
        <a href="<?php echo e(url('/user/create')); ?>" class="ui green small button">
            <i class="plus icon"></i> 新增帳號
        </a>
        <?php endif; ?>
    </h1>
    <div class="ui divider"></div>
    <table id="user-table" class="ui very basic table">
        <thead>
            <tr>
                <th>帳號</th>
                <th>姓名</th>
                <th>更新日期</th>
                <th>創建日期</th>
                <th width="100"></th>
            </tr>
        </thead>
        <tbody>
        <?php if( !count($list) ): ?>  
            <tr>
                <td colspan="3">
                    <h1 class="ui grey center aligned header">
                        <i class="warning icon"></i>
                        <div class="content">沒有帳號</div>
                    </h1>
                </td>
            </tr>
        <?php endif; ?>
        <?php foreach($list as $v): ?>
            <tr id="user-<?php echo e($v->id); ?>">
                <td><?php echo e($v->email); ?></td>
                <td><?php echo e($v->name); ?></td>
                <td><?php echo e($v->updated_at); ?></td>
                <td><?php echo e($v->created_at); ?></td>
                <td class="right aligned">
                    <a href="<?php echo e(url('/user/'.$v->id.'/edit')); ?>" class="ui icon small orange button">
                        <i class="pencil icon"></i>
                    </a>
                    <?php if($editable && $v->id>2): ?>
                    <a onclick="deleteItem('user', <?php echo e($v->id); ?>)" class="ui icon small red button">
                        <i class="trash icon"></i>
                    </a>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script type="text/javascript">
    <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    $("#user-table").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('sales.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>