
<?php $__env->startSection('content'); ?>
<div class="ui centered grid">
    <div class="sixteen wide mobile ten wide tablet six wide computer column">
        <h1 class="ui inverted center aligned header">
            <img src="<?php echo e(asset('images/logo.png')); ?>" id="logo_img">
            <div class="content"></div>
        </h1>
        <form class="ui form left aligned segment" role="form" method="POST" action="<?php echo e(url('/login')); ?>">
            <?php echo e(csrf_field()); ?>

            <div class="field">
                <label>Email</label>
                <input type="text" name="email" placeholder="account@mail.com" value="<?php echo e(old('email','')); ?>">
            </div>
            <div class="field">
                <label>Password</label>
                <input type="password" name="password" placeholder="Please insert password">
            </div>
            <div class="field">
                <label for="captcha">Captcha</label>
                <div class="inline fields">
                    <div class="field">
                        <img src="<?php echo e(captcha_src('flat')); ?>" alt="">
                    </div>
                    <div class="field">
                        <input type="text" name="captcha" id="captcha" placeholder="insert captcha">
                    </div>
                </div>
            </div>
            <div class="field">
                <div class="ui checkbox">
                    <input type="checkbox" name="remember" id="remeber" />
                    <label for="remeber">Remember me</label>
                </div>
            </div>
            <div class="field">
                <?php if(count($errors) > 0): ?>
                <div class="ui error message visible">
                    <div class="ui dividing header">登入失敗</div>
                    <?php foreach($errors->all() as $error): ?>
                        <p><?php echo e($error); ?></p>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?> 
            </div>
            <button class="fluid ui blue button" type="submit">Sign in</button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.auth.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>