

<?php $__env->startSection("content"); ?>
<div class="sixteen wide column">
    <h1 class="ui header">
        功能管理 
        <a href="<?php echo e(url('/func/create')); ?>" class="ui green small button">
            <i class="plus icon"></i> 新增功能
        </a>
    </h1>
    <div class="ui divider"></div>
    <?php if( !count($list) ): ?>  
    <h1 class="ui grey header">
        <i class="warning icon"></i>
        <div class="content">沒有功能</div>
    </h1>
    <?php endif; ?>
    <div id="func-accordion" class="ui accordion list">
    <?php foreach($list as $v): ?>  
        <div class="item" id="func-<?php echo e($v->id); ?>">
            <div class="title">
                <?php if( count($v->child()) ): ?>
                <i class="dropdown icon"></i>
                <?php else: ?>
                <i class="icon"></i>
                <?php endif; ?>
                <span><?php echo e($v->name); ?> / <?php echo e($v->slug); ?></span>
                <div class="right floated">
                    <div class="ui labeled small input">
                        <div class="ui label">排序</div>
                        <input type="text" name="sort" value="<?php echo e($v->sort); ?>" onchange="updateSort(this,<?php echo e($v->id); ?>);">
                    </div>
                    <a href="<?php echo e(url('/func/'.$v->id.'/edit')); ?>" class="ui icon small orange button"><i class="pencil icon"></i></a>
                    <a onclick="notification('func', <?php echo e($v->id); ?>)" class="ui icon small red button"><i class="trash icon"></i></a>
                </div>
            </div>
            <?php if( count($v->child()) ): ?>
            <div class="content">
                <?php foreach($v->child() as $c): ?>
                    <div class="title" id="func-<?php echo e($c->id); ?>">
                        <!-- <i class="dropdown icon"></i> -->
                        <span><?php echo e($c->name); ?> / <?php echo e($c->slug); ?></span>
                        <div class="right floated">
                            <div class="ui labeled small input">
                                <div class="ui label">排序</div>
                                <input type="text" name="sort" value="<?php echo e($c->sort); ?>" onchange="updateSort(this,<?php echo e($c->id); ?>);">
                            </div>
                            <a href="<?php echo e(url('/func/'.$c->id.'/edit')); ?>" class="ui icon small orange button"><i class="pencil icon"></i></a>
                            <a onclick="notification('func', <?php echo e($c->id); ?>)" class="ui icon small red button"><i class="trash icon"></i></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
<script type="text/javascript">
    
    <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    function notification(type, id) {
        if( confirm("刪除可能會影響到下層功能，是否確認刪除？") ) {
            deleteItem(type, id);
        }
    }
    $("#func-accordion").accordion({
        selector: {
          trigger: '.title .icon'
        }
    });


    function updateSort(tag, id) {
        var val = tag.value;
        $.ajax({
            url: host+"/func/"+id,
            method: "PUT",
            data: { 
                _token: $('meta[name="csrf_token"]').attr('content'),
                _method: "PUT",
                sort: val
            },
            dataType: "json",
            beforeSend: function (argument) {
                // body...
            }
        }).done(function(r){
            if( r ) {
                $(".ui.message").html("<b>排序修改成功</b>").slideDown();
            } else {
                $(".ui.message").html("<b>排序修改失敗</b>").slideDown();
            }
            hideMessage();
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('sales.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>